#!/bin/bash

usage() {

cat  <<EOF
Usage: 
$0 N hosts "ARGS"
where:
      N: number of MPI ranks
      hosts: host1[:N1],host2[:N2],... comma-delimited hosts list with optional host's ranks amount
      "ARGS": arguments to pass to Arion (multi-word arguments must be enclosed in double quotes)
EOF
exit

}

if [[ "$0" != \/* ]]; then
    echo Call to this script must be an absolute path
    usage
fi

minargs=3
if [ $# -lt $minargs ]; then
    usage
fi


basedir=$(dirname "$0")

exewrapper="$basedir/arion2.6_impi2021.sh"
mpirunexe="mpirun"

source /opt/intel/oneapi/mpi/2021.16/env/vars.sh

exec "$mpirunexe" -print-rank-map -n $1 -hosts $2 "$exewrapper" $3 

