#!/bin/bash

usage() {

cat  <<EOF
Usage: 
$0 N "ARGS"
where:
      N: number of MPI ranks
      "ARGS": arguments to pass to Arion (multi-word arguments must be enclosed in double quotes)
EOF
exit

}

if [[ "$0" != \/* ]]; then
    echo Call to this script must be an absolute path
    usage
fi

minargs=2
if [ $# -lt $minargs ]; then
    usage
fi


basedir=$(dirname "$0")

exewrapper="$basedir/arion2.6_impi2021.sh"
mpirunexe="mpirun"

source /opt/intel/oneapi/mpi/2021.16/env/vars.sh

exec "$mpirunexe" -print-rank-map -n $1 "$exewrapper" "$2"  

