#This script sets up the bash shell environment for running dynamically linked stdc++ executabes when the one that is supplied with the os is incomatible with the executable.
dirnameiscfdc="/usr/local/iscfdc"
dirnames=("$dirnameiscfdc")
if [ $# -gt 0 ]; then
    dirname="$1"
    if [[ "$dirname" != \/* ]]; then 
        dirname="$PWD/$dirname"
    fi
    dirnames=("$dirname" "$dirnameiscfdc")
fi

LD_LIBRARY_PATH_NEW=
PYTHONPATH_NEW=
CANTERA_DATA_NEW=
ISCFDC_DATA_NEW=
ok=no

for dirname in ${dirnames[*]}
do
    if [ "x$ok" != "xyes" ]; then 
    
    #order of tests:
        pythonexist=not
        libsexist=not
        cdataisset=not
    #reset values
        LD_LIBRARY_PATH_NEW=

        if [ "x$LD_LIBRARY_PATH" != "x" ]; then
            LD_LIBRARY_PATH_NEW="$LD_LIBRARY_PATH"
        fi
        
        PYTHONPATH_NEW=
        if [ "x$PYTHONPATH" != "x" ]; then
            PYTHONPATH_NEW="$PYTHONPATH"
        fi
        CANTERA_DATA_NEW=
        ISCFDC_DATA_NEW=

        #python setup
        if [ -f "$dirname/Python-3.12.7_cantera/bin/python3.12" ]; then
            PYTHON_CMD_NEW="$dirname/Python-3.12.7_cantera/bin/python3.12"
            pythonexist=yes
            
            if [ "x$LD_LIBRARY_PATH_NEW" == "x" ]; then
                LD_LIBRARY_PATH_NEW="$dirname/Python-3.12.7_cantera/lib"
            else
                LD_LIBRARY_PATH_NEW="$dirname/Python-3.12.7_cantera/lib:$LD_LIBRARY_PATH_NEW"
            fi
            export PATH="$dirname/Python-3.12.7_cantera/bin/":$PATH
        fi
        #done python

        #libraries:
        if [ -f "$dirname/lib/libstdc++.so.6" ]; then 
            if [ -f "$dirname/lib/libgcc_s.so.1" ]; then 
                libsexist=yes
                if [ "x$LD_LIBRARY_PATH_NEW" == "x" ]; then
                    LD_LIBRARY_PATH_NEW="$dirname/lib"
                else
                    LD_LIBRARY_PATH_NEW="$dirname/lib:$LD_LIBRARY_PATH_NEW"
                fi
            fi
        fi   
        #done libraries

        #cantera data:
        cdataexist=yes
        if [ ! -d "$dirname/data/cantera" ]; then 
            if [ ! -L "$dirname/data/cantera" ]; then
                cdataexist=not
            fi
        fi

        CANTERA_DATA_NEW="$dirname/data/cantera/"
        ISCFDC_DATA_NEW="$dirname/data/"
        #done cantera

        #check all
        ## pythonexist=not
        ## libsexist=not
        ## cdataisset=not

        if [ "x$pythonexist" == "xyes" ]; then
            if [ "x$libsexist" == "xyes" ]; then
                if [ "x$cdataexist" == "xyes" ]; then
                    export LD_LIBRARY_PATH="$LD_LIBRARY_PATH_NEW"
                    export PYTHON_CMD="$PYTHON_CMD_NEW"
                    export CANTERA_DATA="$CANTERA_DATA_NEW"
                    export ISCFDC_DATA="$ISCFDC_DATA_NEW"
                    echo LD_LIBRARY_PATH "$LD_LIBRARY_PATH_NEW"
                    echo PYTHON_CMD "$PYTHON_CMD_NEW"
                    echo CANTERA_DATA "$CANTERA_DATA_NEW"
                    echo ISCFDC_DATA "$ISCFDC_DATA_NEW"
                    ok=yes
                fi
            fi
        fi

    fi 
    #"x$ok" != "xyes"

    if [ "x$debug" != "x" ]; then 
        if [ "x$ok" != "xyes" ]; then
        set -x 
            if [ "x$pythonexist" != "xyes" ]; then
                echo "cound't find python"
            fi
            
            if [ "x$libsexist" != "xyes" ]; then
                echo "cound't find shared libraries"
            fi

            if [ "x$cdataexist" != "xyes" ]; then
                echo "cound't find CANTERA data"
            fi
        fi
    fi
done


