#!/bin/bash

usage() {

cat  <<EOF
Usage: 
$0 N hosts "ARGS"
where:
      N: number of MPI ranks
      hosts: host1,host2,... comma-delimited hosts list
      "ARGS": arguments to pass to Arion (multi-word arguments must be enclosed in double quotes)
EOF
exit

}

if [[ "$0" != \/* ]]; then
    echo Call to this script must be an absolute path
    usage
fi

minargs=3
if [ $# -lt $minargs ]; then
    usage
fi


basedir=$(dirname "$0")

mpidir="$basedir/openmpi-1.8.4_intel2018"
exewrapper="$basedir/arion2.6_openmpi-1.8.4.sh"
mpirunexe="$basedir/openmpi-1.8.4_intel2018/bin/mpirun"

export LD_LIBRARY_PATH="$basedir/lib:$basedir/openmpi-1.8.4_intel2018/lib"
export OPAL_PREFIX="$mpidir"

exec "$mpirunexe" -n $1  --report-bindings --map-by node --bind-to core -host "$2" "$exewrapper" $3

