#This script sets up the tcsh shell environment for running dynamically linked stdc++ executabes when the one that is supplied with the os is incomatible with the executable. 


set dirnameiscfdc="/usr/local/iscfdc"

if ( $#argv != 0 ) then
    set dirname1="$1"
else
    set dirname1="$HOME"
endif

set LD_LIBRARY_PATH_NEW=
set PYTHONPATH_NEW=
set CANTERA_DATA_NEW=
set ISCFDC_DATA_NEW=
set ok=no

foreach dirname ("$dirname1" "$dirnameiscfdc")

    if ( "x$ok" != "xyes" ) then 
#order of tests:
        set pythonexist=not
        set libsexist=not
        set cdataisset=not
    #reset values
        set LD_LIBRARY_PATH_NEW=

        if ( ${?LD_LIBRARY_PATH} != 0 ) then
            set LD_LIBRARY_PATH_NEW="$LD_LIBRARY_PATH"
        endif
        
        set PYTHONPATH_NEW=
        if ( ${?PYTHONPATH} != 0 ) then
            set PYTHONPATH_NEW="$PYTHONPATH"
        endif
        set CANTERA_DATA_NEW=
        set ISCFDC_DATA_NEW=

        #python setup
        if ( -f "$dirname/Python-3.12.7_cantera/bin/python3.12" ) then
            set PYTHON_CMD_NEW="$dirname/Python-3.12.7_cantera/bin/python3.12"
            set pythonexist=yes

            if ( "x$LD_LIBRARY_PATH_NEW" == "x" ) then
                set LD_LIBRARY_PATH_NEW="$dirname/Python-3.12.7_cantera/lib"
            else
                set LD_LIBRARY_PATH_NEW="$dirname/Python-3.12.7_cantera/lib:$LD_LIBRARY_PATH_NEW"
            endif
            set path=("$dirname/Python-3.12.7_cantera/bin/" $path) ; rehash
        endif
        #end python

        #libraries:
        if ( -f "$dirname/lib/libstdc++.so.6" ) then 
            if ( -f "$dirname/lib/libgcc_s.so.1" ) then 
                set libsexist=yes
                if ( "x$LD_LIBRARY_PATH_NEW" == "x" ) then
                    set LD_LIBRARY_PATH_NEW="$dirname/lib"
                else
                    set LD_LIBRARY_PATH_NEW="$dirname/lib:$LD_LIBRARY_PATH_NEW"
                endif
            endif
        endif
        #end libraries

        #cantera data:
        set cdataexist=yes
        if ( ! -d "$dirname/data/cantera" ) then 
            if ( ! -l "$dirname/data/cantera" ) then
                set cdataexist=not
            endif
        endif

        set CANTERA_DATA_NEW="$dirname/data/cantera/"
        set ISCFDC_DATA_NEW="$dirname/data/"
        #end cantera

        #check all
        ## pythonexist=not
        ## libsexist=not
        ## cdataisset=not

        if ( "x$pythonexist" == "xyes" ) then
            if ( "x$libsexist" == "xyes" ) then
                if ( "x$cdataexist" == "xyes" ) then
                    setenv LD_LIBRARY_PATH "$LD_LIBRARY_PATH_NEW"
                    setenv PYTHON_CMD "$PYTHON_CMD_NEW"
                    setenv CANTERA_DATA "$CANTERA_DATA_NEW"
                    setenv ISCFDC_DATA "$ISCFDC_DATA_NEW"
                    echo LD_LIBRARY_PATH "$LD_LIBRARY_PATH_NEW"
                    echo PYTHON_CMD "$PYTHON_CMD_NEW"
                    echo CANTERA_DATA "$CANTERA_DATA_NEW"
                    echo ISCFDC_DATA "$ISCFDC_DATA_NEW"
                    set ok=yes
                endif
            endif
        endif

    endif 
    #"x$ok" != "xyes"

    if ( ${?debug} != 0 ) then 
        if ( "x$ok" != "xyes" ) then 
            if ( "x$pythonexist" != "xyes" ) then
                echo "cound't find python"
            endif
            
            if ( "x$libsexist" != "xyes" ) then
                echo "cound't find shared libraries"
            endif

            if ( "x$cdataexist" != "xyes" ) then
                echo "cound't find CANTERA data"
            endif
        endif
    endif

end
