#!/bin/bash

usage() {

cat  <<EOF
Usage: 
$0 N "ARGS"
where:
      N: number of MPI ranks
      "ARGS": arguments to pass to Arion (multi-word arguments must be enclosed in double quotes)
EOF
exit

}

if [[ "$0" != \/* ]]; then
    echo Call to this script must be an absolute path
    usage
fi

minargs=2
if [ $# -lt $minargs ]; then
    usage
fi


basedir=`dirname $0`

mpidir="$basedir/openmpi-4.1.4_intel2018"
exewrapper="$basedir/arion2.6_openmpi-4.1.4.sh"
mpirunexe="$basedir/openmpi-4.1.4_intel2018/bin/mpirun"

export LD_LIBRARY_PATH="$basedir/lib:$basedir/openmpi-4.1.4_intel2018/lib"
export OPAL_PREFIX="$mpidir"

exec "$mpirunexe" -n $1 --report-bindings --mca btl ^openib,tcp  "$exewrapper" $2

